use <parts/RPi-four-in-a-row.scad>;
use <parts/power-supply.scad>;
use <parts/power-plug.scad>;
use <parts/switch.scad>;
$fn=50;


module case () {
    rotate([90,0,0])
    translate([26.1,-10,-58.5])
    difference () {
        color("red")
        minkowski()
        {
            cube([125,100,66]);
            cylinder(r=30,h=1);
        }
        translate([3.5,3.5,0])
        minkowski()
        {
            cube([118,93,59.5]);
            cylinder(r=30,h=1.1);
        }
    }
}

module top () {
    rotate([90,0,0])
    translate([26.1,-10,-62])
    color("yellow")
    union () {
        minkowski()
        {
            cube([125,100,2]);
            cylinder(r=30,h=1);
        }
        translate([3.5,3.5,0])
        minkowski()
        {
            cube([118,93,4]);
            cylinder(r=30,h=1.1);
        }
    }
}


module plug(){
        translate([99,10,120.0])
        rotate([180,0,0])
        powerPlug();
}

module switches () {
    translate([37,40,120.0])
    rotate([180,0,0])
    switch();

    translate([62,40,120.0])
    rotate([180,0,0])
    switch();

    translate([87,40,120.0])
    rotate([180,0,0])
    switch();

    translate([112,40,120.0])
    rotate([180,0,0])
    switch();

}

module caseWithHoles () {
    difference () {
        case();
        holes();
        plug();
        switches();
    }

    %plug();
    %switches();
    



}

module ventilationHoles () {
    step = 14;
    startX = -70;
    startY = 115;
    radius = 3;
    rotate([90,90,0])
    translate([startX,startY,-64])
    for (xaxis = [0:4]) {
        for (yaxis = [0:3]) {
            translate([xaxis*step,yaxis*step,0])
            cylinder(r=radius,h=8);
        }
    }

}

module topWithHoles () {
    difference () {
        top();
        holes();
        ventilationHoles();
    }


}

//rpiPCBs();
slots();


caseWithHoles();
// topWithHoles();

translate([97,-2.1,-14])
rotate([90,-90,180])
powerSupplyScrewHoles();


