$fn = 30;

module rpi2 (){
    render(){
        import("../boards/rpi2-board.stl");
    }
}

module rpi3 (){
    render(){
        rotate([0,0,180])
        translate([-84.9,-57.4,-3.9])
        import("../boards/rpi3-board.stl");
    }
}

module tinker (){
    render(){
        rotate([90,0,180])
        translate([-42.5,-1.65,28])
        import("../boards/tinker-board.stl");
    }
}



module rpiHoles () {

    // ethernet
    color("yellow")
    translate([-4,37,-0.5])
    cube([6,17.5,16]);

    color("red")
    translate([-2,36.5,-1])
    cube([4.5,18.5,17]);


    // usb
    color("yellow")
    translate([-4,19.25,-0.75])
    cube([6,15.5,16.5]);

    color("red")
    translate([-2.5,18.75,-1.25])
    cube([4.5,16.5,17.5]);

    color("yellow")
    translate([-4,1.25,-0.75])
    cube([6,15.5,16.5]);
    
    color("red")
    translate([-2.5,0.75,-1.25])
    cube([4.5,16.5,17.5]);


    // power
    translate([70,53,-0.5])
    cube([9,12,3.5]);

    translate([76.4,59,1.3])
    rotate([270,90,0])   
    hull() {
        translate([0,4,0]) 
        cylinder(r1=3.5,r2=5,h=5);
        cylinder(r1=3.5,r2=5,h=5);
    }


    // hdmi
    translate([45,53,-0.5])
    cube([16,12,7]);

    translate([58.4,59,2.8])
    rotate([270,90,0])   
    hull() {
        translate([0,11,0]) 
        cylinder(r1=5,r2=8,h=5);
        cylinder(r1=5,r2=8,h=5);
    }

    // audio jack
    translate([31.4,65,2.8])
    rotate([90,0,0])
    cylinder(r=3.5,h=12);

    translate([31.4,63,2.8])
    rotate([90,0,0])
    cylinder(r1=7,r2=3.5,4);
}


module rpiSlot() {
    // slot
    difference () {

        union () {

            // slot holder
            translate([79,-2,-4.5])
            cube([7,9,7]);

            translate([0,-2,-3.5])
            cube([85,2.5,5]);
        }

        translate([0,0,-1.9])
        cube([86,8,2]);
        
        translate([81.4,3.5,-6])
        cylinder(r=1.5,h=10);
        
    }
    difference () {
        color("yellow")
        translate([79+7,-2,-4.5])
        cube([6,9,7]);

        color("red")
        translate([86,4,-1.9])
        rotate([0,0,45])
        cube([4,4,2]);

    }

        
}


//translate([0,0,50])

//rpi3();
//tinker();

rpiSlot();
rpiHoles();


// Netzteil
// SNT RS 25 5
// https://www.reichelt.de/?ARTICLE=137084&PROVID=2788&wt_mc=amc141526782519998&gclid=CNqxxaTLlNICFUWfGwod5mQChw
//translate([0,0,75])
//cube([78,51,28]);
